/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.autotool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_7923;

public final class AutoToolMod {
    public static final String MOD_ID = "auto_tool";
    public static boolean USE_BEST_TOOL = true;
    public static boolean AVOID_LOW_DURABILITY = true;
    public static float MINIMUM_DURABILITY_PERCENTAGE = 0.05f;
    public static boolean TOOL_SWAP_ENABLED = true;
    private static final File CONFIG_FILE = new File(Platform.getConfigFolder().toFile(), "auto_tool_config.json");
    private static final Map<String, ToolType> PREFERRED_TOOLS = new LinkedHashMap<String, ToolType>();
    private static class_304 toggleToolSwapKeybind;
    private static int lastAnnouncedSlot;
    private static final Gson GSON;

    public static void init() {
        AutoToolMod.loadConfig();
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        AutoToolMod.registerKeybinds();
        ClientTickEvent.CLIENT_PRE.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            if (client.field_1755 != null) {
                return;
            }
            if (client.field_1724.method_6115()) {
                return;
            }
            if (class_310.method_1551().field_1690.field_1886.method_1434()) {
                AutoToolMod.handleBlockBreaking((class_1657)client.field_1724, (class_1937)client.field_1687);
            }
            if (toggleToolSwapKeybind.method_1436()) {
                AutoToolMod.toggleToolSwap((class_1657)client.field_1724);
            }
        });
    }

    private static void registerKeybinds() {
        toggleToolSwapKeybind = new class_304("key.auto_tool.toggle_swap", 342, "key.categories.misc");
        KeyMappingRegistry.register((class_304)toggleToolSwapKeybind);
    }

    private static void toggleToolSwap(class_1657 player) {
        TOOL_SWAP_ENABLED = !TOOL_SWAP_ENABLED;
        player.method_7353((class_2561)class_2561.method_43471((String)(TOOL_SWAP_ENABLED ? "message.auto_tool.enabled" : "message.auto_tool.disabled")), true);
        AutoToolMod.saveConfig();
    }

    private static void handleBlockBreaking(class_1657 player, class_1937 level) {
        if (!TOOL_SWAP_ENABLED) {
            return;
        }
        class_239 hit = player.method_5745(5.0, 0.0f, false);
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2338 pos = ((class_3965)hit).method_17777();
        class_2680 state = level.method_8320(pos);
        if (!state.method_26215()) {
            AutoToolMod.autoSwitchTool(player.method_31548(), state);
        }
    }

    private static void autoSwitchTool(class_1661 inv, class_2680 state) {
        int chosen;
        int current = inv.field_7545;
        ToolType preferred = AutoToolMod.getPreferredToolForBlock(state);
        int bestIdxPreferred = -1;
        float bestSpeedPreferred = -1.0f;
        int bestIdxGeneral = -1;
        float bestSpeedGeneral = USE_BEST_TOOL ? 1.0f : Float.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960() || AVOID_LOW_DURABILITY && AutoToolMod.isToolDurabilityLow(stack)) continue;
            float speed = stack.method_7924(state);
            boolean correctForDrops = stack.method_7951(state);
            ToolType stackType = AutoToolMod.getToolType(stack.method_7909());
            if (preferred != null && stackType == preferred && (speed > bestSpeedPreferred || speed == bestSpeedPreferred && correctForDrops)) {
                bestSpeedPreferred = speed;
                bestIdxPreferred = i;
            }
            if (USE_BEST_TOOL) {
                if (!(speed > bestSpeedGeneral) && (speed != bestSpeedGeneral || !correctForDrops)) continue;
                bestSpeedGeneral = speed;
                bestIdxGeneral = i;
                continue;
            }
            if (!(speed > 1.0f) || !(speed < bestSpeedGeneral)) continue;
            bestSpeedGeneral = speed;
            bestIdxGeneral = i;
        }
        int n = chosen = preferred != null && bestIdxPreferred != -1 ? bestIdxPreferred : bestIdxGeneral;
        if (chosen != -1 && chosen != current) {
            inv.field_7545 = chosen;
            if (lastAnnouncedSlot != chosen && class_310.method_1551().field_1724 != null) {
                class_1792 item = inv.method_5438(chosen).method_7909();
                String toolType = AutoToolMod.getToolTypeName(item);
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"message.auto_tool.switched", (Object[])new Object[]{toolType}), true);
                lastAnnouncedSlot = chosen;
            }
        }
    }

    private static ToolType getPreferredToolForBlock(class_2680 state) {
        class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
        if (id == null) {
            return null;
        }
        String key = id.toString();
        ToolType t = PREFERRED_TOOLS.get(key);
        if (t != null) {
            return t;
        }
        for (Map.Entry<String, ToolType> e : PREFERRED_TOOLS.entrySet()) {
            String prefix;
            String pattern = e.getKey();
            if (!pattern.endsWith("*") || !key.startsWith(prefix = pattern.substring(0, pattern.length() - 1))) continue;
            return e.getValue();
        }
        return null;
    }

    private static boolean isToolDurabilityLow(class_1799 stack) {
        float threshold;
        if (!stack.method_7963()) {
            return false;
        }
        int remaining = stack.method_7936() - stack.method_7919();
        float pct = (float)remaining / (float)Math.max(1, stack.method_7936());
        return pct <= (threshold = Math.max(0.0f, Math.min(1.0f, MINIMUM_DURABILITY_PERCENTAGE)));
    }

    private static String getToolTypeName(class_1792 item) {
        switch (AutoToolMod.getToolType(item).ordinal()) {
            case 0: {
                return "Pickaxe";
            }
            case 1: {
                return "Axe";
            }
            case 2: {
                return "Shovel";
            }
            case 3: {
                return "Hoe";
            }
            case 4: {
                return "Sword";
            }
            case 5: {
                return "Shears";
            }
        }
        return "Tool";
    }

    private static ToolType getToolType(class_1792 item) {
        if (item instanceof class_1810) {
            return ToolType.PICKAXE;
        }
        if (item instanceof class_1743) {
            return ToolType.AXE;
        }
        if (item instanceof class_1821) {
            return ToolType.SHOVEL;
        }
        if (item instanceof class_1794) {
            return ToolType.HOE;
        }
        if (item instanceof class_1829) {
            return ToolType.SWORD;
        }
        if (item instanceof class_1820) {
            return ToolType.SHEARS;
        }
        return ToolType.OTHER;
    }

    private static void loadConfig() {
        if (PREFERRED_TOOLS.isEmpty()) {
            PREFERRED_TOOLS.put("minecraft:mushroom_stem", ToolType.AXE);
            PREFERRED_TOOLS.put("minecraft:brown_mushroom_block", ToolType.AXE);
            PREFERRED_TOOLS.put("minecraft:red_mushroom_block", ToolType.AXE);
            PREFERRED_TOOLS.put("minecraft:bamboo", ToolType.SWORD);
        }
        if (!CONFIG_FILE.exists()) {
            AutoToolMod.saveConfig();
            return;
        }
        try (FileInputStream in = new FileInputStream(CONFIG_FILE);
             InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (json.has("useBestTool")) {
                USE_BEST_TOOL = json.get("useBestTool").getAsBoolean();
            }
            if (json.has("avoidLowDurability")) {
                AVOID_LOW_DURABILITY = json.get("avoidLowDurability").getAsBoolean();
            }
            if (json.has("minimumDurabilityPercentage")) {
                MINIMUM_DURABILITY_PERCENTAGE = json.get("minimumDurabilityPercentage").getAsFloat();
            }
            if (json.has("toolSwapEnabled")) {
                TOOL_SWAP_ENABLED = json.get("toolSwapEnabled").getAsBoolean();
            }
            if (json.has("preferredTools") && json.get("preferredTools").isJsonObject()) {
                JsonObject prefs = json.getAsJsonObject("preferredTools");
                for (Map.Entry e : prefs.entrySet()) {
                    String blockKey = (String)e.getKey();
                    String val = ((JsonElement)e.getValue()).getAsString();
                    if ("NONE".equalsIgnoreCase(val)) {
                        PREFERRED_TOOLS.remove(blockKey);
                        continue;
                    }
                    ToolType tt = ToolType.fromString(val);
                    if (tt == null) continue;
                    PREFERRED_TOOLS.put(blockKey, tt);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AutoToolMod.saveConfig();
        }
    }

    private static void saveConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("useBestTool", Boolean.valueOf(USE_BEST_TOOL));
        json.addProperty("avoidLowDurability", Boolean.valueOf(AVOID_LOW_DURABILITY));
        json.addProperty("minimumDurabilityPercentage", (Number)Float.valueOf(MINIMUM_DURABILITY_PERCENTAGE));
        json.addProperty("toolSwapEnabled", Boolean.valueOf(TOOL_SWAP_ENABLED));
        JsonObject prefs = new JsonObject();
        for (Map.Entry<String, ToolType> e : PREFERRED_TOOLS.entrySet()) {
            prefs.addProperty(e.getKey(), e.getValue().name());
        }
        json.add("preferredTools", (JsonElement)prefs);
        try (FileOutputStream out = new FileOutputStream(CONFIG_FILE);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
             JsonWriter writer = new JsonWriter((Writer)osw);){
            writer.setIndent("  ");
            GSON.toJson((JsonElement)json, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        lastAnnouncedSlot = -1;
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    private static enum ToolType {
        PICKAXE,
        AXE,
        SHOVEL,
        HOE,
        SWORD,
        SHEARS,
        OTHER;


        static ToolType fromString(String s) {
            if (s == null) {
                return null;
            }
            try {
                return ToolType.valueOf(s.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }
}

